# 第七章 开源商业现状

开源的商业模式经历了三代演进，商业闭环已经形成，Open Core和基于开源的商业产品加上云原生（Cloud Native）成为了开源商业化大爆发最为重要的内在因素。而随着数字化时代的到来，中国迎来了开源创业的浪潮。在2021年，中国开源公司融资数量实现了几乎翻倍的增长，从融资分布的技术领域来看，主要集中在数据库、云原生和人工智能上。同时，做开源项目，一定要有全球化的视野，能够触达到全世界的用户和开发者，这是一个巨大的机会。
 
## 7.1 开源商业化呈现井喷之势，中国迎来开源创业的浪潮

开源作为一种高效的协作方式，让更多的开发者参与并产出更高质量的源代码。同时，“开源带货”逐渐盛行，通过开源的方式帮助产品及企业触及更多用户，由此带来了巨大的商业化或专业版本服务的机会。还有非常关键的一点是，开源是基础软件的最佳选择，相比很难让用户接受的闭源“黑箱”和供应商锁定，开源基础软件众所周知的开放生态和可移植性能够促使更多的用户来使用。但对于企业用户而言，由于开源软件在保证（Warranty）和许可证条款、商务模式、技术支持模式等各个方面与商业软件的根本不同，过去由商业软件公司提供的整个产品生命周期过程中的责任与服务，现在完全由企业客户自己承担。虽然有些企业将部分责任转嫁给开发项目组、应用开发商或人力外包供应商，但在实践中却发现，开发项目组频繁重组、应用开发商既做运动员又做裁判员，人力外包供应商更关注成本和项目周期，真正发生问题时，绝大部分管理和支持责任仍需企业自己承担。因此开源商业化中基于开源的商业产品和服务都变得非常重要。基于开源的商业产品和服务不仅能让企业客户体验开源带来的开放生态，避免供应商锁定，同时享受供应商提供的商务保证和服务水平协议等。

从2013年开始，开源商业化在国际市场取得了较大的突破，实现了10倍速的增长。开源产品的优越性得到了更好的验证，在商业上也落地生花。非常显著的一点是，收入过1亿美金的开源公司有了爆发性的增长，从屈指可数的几家迅速增长至如今的五十余家。比如，在2021年里，Confluent（Kafka背后的开源商业公司）、HashiCorp、GitLab成功上市，市值都在百亿美元规模，开源的商业模型已经得到了良好验证。

在中国市场，随着数字化时代的到来，每个行业都迎来巨变，过去不具备开发者技术力量的传统公司都在转型为技术公司。我们已经可以看到当今诸多市值很高的公司背后，都是技术在驱动，由此开源成为重中之重。开源已经成为了整个互联网产业的基石，几乎所有的互联网公司都在使用开源软件，它极大地降低了软件生产的成本，随着商业化的发展，也将让更多的企业享受到开源带来的好处。

数字经济拉动了技术本身的发展，和商业模式闭环的形成，由此，中国迎来了开源创业的浪潮。据CSDN关于中国开源项目融资的数据统计显示，在2021年，开源融资较2020年实现了几乎翻倍的增长。同时我们也可以看到，融资分布的技术领域，主要集中在数据库、云原生和人工智能。

中国要在全球开源立住脚，一方面要发展头部公司，另一方面，应该利用工程师红利。中国拥有全球最大的开发者群体，让开发者大量涌入开源世界做贡献，通过开源协作开发出更多有用的软件。其次，将软件与硬件进行结合也是一个巨大的优势。

![](https://img-blog.csdnimg.cn/66fb71f8dcbb4a378c6057a25b4cdaa5.jpeg)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>表20 中国开源项目融资列表
</span>
（来源：CSDN统计汇总 https://gitcode.net/open-source-lab/List-of-Chinese-Open-Source-Project-Financing）

## 7.2 开源商业模式：Open Core加云原生成主流

开源项目的商业模式有着不同的路径和阶段，总体来说，经历了三代演进：

第一代，支持和服务为主的模式，以红帽和IBM技术支持服务为代表。基于开源的商业产品，在开源组件的基础上，增加了功能安全和性能等企业用户所要求的属性，并提供开源许可证之外的商务保证和服务水平协议。这在现在以及未来依然会是企业客户的主要需求。

第二代，以MongoDB、Cloudera等为代表，有开源项目，做付费的商业版本。这个模式不太成功。

第三代，本身可能拥有基础软件属性，且能够提供云服务的Open Core模式和基于开源的商业产品，可以在商业上形成闭环。可以说，Open Core和基于开源的商业产品加上云原生（Cloud Native），是开源商业化大爆发最为重要的内在因素。其外部因素就是在数字经济的驱动下，这个模式形成了飞轮效应。

具体到开源模式上，我们可以总结归纳出以下几种主要的商业模式：

* 订阅式产品化和技术支持模式：类似于红帽基于Linux社区版做了Linux企业版,并以订阅的方式长期向企业客户收费。此外，还基于开源项目提供打包、培训或咨询服务类的技术支持。
* 开源服务模式：指企业提供包括开源咨询、开源支持托底等服务体系。其中开源咨询服务可以帮助企业建设开源软件从引入到退出的生命周期管理机制和工具、评估存量开源软件的成熟度和使用风险，建设落地开源软件管理平台和工具，做好开源软件引入及退出体系标准和建设。而开源支持托底服务依托于开源服务提供商既有的软件支持体系和工具，可以用本地支持-远程专家-全球团队的支持模式，提供包括应急支持、性能调优、架构优化、定期风险公告等多方面的服务，帮助企业客户在享受开源软件便利性的同时，仍可享有商业软件的支持服务水平。这方面的代表企业有IBM、红帽和SUSE。
* 基于开源的商业产品模式：结合开源并按照企业客户需求增值功能、性能安全等附加能力，以商业产品发布。在2022年信通院公布的第二批开源供应商目录中包含了很多这类基于开源的商业产品，比如甲骨文的Oracle Linux、IBM的Cloud Pak和区块链平台IBP、百度的数据仓库Doris等。
* 社区版开源，增值闭源的Open Core模式：把一部分软件开源，另一部分增值的闭源收费。我们经常见到很多“社区版”的软件可能就是开源的，而与之对应的“企业版”的模式就有可能提供了很多额外功能并收费。采用这类模式的有Kafka、Cassandra、GitLab等。
* Dual-License双授权模式：指代码具有两套许可证。一套是传统的开源许可证（如GPL），另一套是商业许可证。
* SaaS - 软件即服务上云模式：商业变现的一开始就决定把软件运营到云上，用SaaS服务的方式对使用者提供“可租用的软件服务”，而不是把软件的所有权卖给用户，让用户自己去运维。SaaS的好处很多，从营收模型上看，客户会每月、每年源源不断地贡献收入，容易获得高估值。对客户的好处不言而喻，主要包括：避免前期一次性购买软件和专用硬件的高额成本；部署快、随时享受升级；运维责任转嫁到了SaaS提供商身上，有供应商提供管理服务。
* 广告收益型：为了将开源商业化，包括Google、Mozilla和Canonical等在内的许多公司都已经转向了广告支持软件的商业模式。还有如开源项目服务提供商SourceForge这样在网站上采用广告横幅销售收入的模式。
* 其他模式：利用开源软件来搭建应用系统，通过开源更快更便捷地获取基于开源操作系统的生态合作伙伴，通过开源生态上的产品分成等模式。

## 7.3 开源商业公司的护城河：得生态者得天下

如果企业想要基于开源来构建核心技术，在公司的发展过程中，如何通过开源技术形成持续的竞争力，确保后来者难以快速抄袭或超越？首先最为关键的就是构建生态。好的生态是最强的竞争优势和护城河。比如基于Open Core的商业模式，解决在某一领域最擅长也是客户关心的痛点问题，并输出成为一个Quick Start。

所谓Quick Start，即开源软件解决某一特定场景问题的实操指南。当用户尝鲜一个开源软件时，一开始下载安装部署，如果突然卡住，按流程文档依然无法运行起来，会大概率流失这个用户。因此，Quick Start至关重要，一定要让进入的门槛特别低，让用户可以立即用起来，后续碰到问题也能够互相帮助解决，甚至想出一些当前软件不具备的功能，并付诸开发，由此就会形成一个围绕该项目的开发者社区。

有了开发者社区后，忠实的用户会将他们使用的方法写成文档并传播，吸引更多的用户进来。这其实就是一个飞轮效应。最终会有越来越多的软件包产生。生态一旦形成，项目的原作者会加大用户对你所提供的服务的信任，这是更高效的开发方式。

当然，源代码只是很小的一部分，更重要的是通过用户的参与形成一个生态。当软件开放后，对市场的需求、用户的认知，会比不开放的更深入。开源的竞争是在一个相对的市场上，竞争更大，也更有长久的生命力。

因此，基于开源项目的商业公司而言，未来的竞争力不应该仅仅停留在代码层面，而是基于代码和面向特定用户服务的能力，构建起开发者和用户的生态，由此形成竞争壁垒。

需要注意的是，任何一个开源软件都有可能被分叉出去，这是一种常态。作为原作者，要对自己有信心，对项目的掌控程度、未来增加新功能的能力应该是最强的，当它跑得越快、更多的功能做起来、软件用户越来越多，分叉并不会带来特别的影响。当然，开源赋予了用户永远选择的权利，无论是分支还是主干，核心都在于谁做得更好、保持领先。

## 7.4 开源项目商业化的建议：一定要有全球化视野

我们正处在开源产业发展最好的机遇期，能够看到非常多的开源初创项目和企业正在快速发展和成长。对于开源企业和创业者而言，如何保持快速的发展，首先要解决一个特定的问题、解决用户痛点，然后给用户创造价值，这是所有商业能够存在的根本。当然，也要反问自己，现在做的这个项目，和市面上现有的软件有何差别，具备哪些独特性，甚至是一个跨代的架构。如果这些存在的话，那么机会是很多的。

另外，做增量市场还是存量市场，有很多详细的策略，将这些充分分析后，能够让开源项目商业化走得更顺一些。

同时，做开源项目，一定要有全球化的视野。通过开源，全世界的用户和开发者都可以触达到，这是一个巨大的机会。
